#!/usr/bin/perl -w
# gcc fails to evaluate trig functions at compile time,
# and of course asm needs precomputed constants

$asm = @ARGV && ($ARGV[0] eq "-asm");

$pi = 3.14159265358979323846;

sub define {
    my ($k,$v) = @_;
    if($asm) {
        $tf .= sprintf "%s: times 4 dd %.15f\n", $k, $v;
        my $bits = 16;
        my $i;
        do {
            $bits--;
            $i = fix($v, $bits);
        } while($i >= (1<<15) || $i < -(1<<15));
        $ti .= sprintf "%s: times 8 dw %d\n", $k, $i;
        if($k =~/:\n/) {
            $ti .= sprintf "%%define %s_shift %s_shift\n", $`, $';
            $k = $';
        }
        $ti .= sprintf "%%define %s_shift %d\n", $k, 15-$bits;
    } else {
        $tf .= sprintf "#undef %s\n#define %s %.15ff\n", $k, $k, $v;
        $ti .= sprintf "#undef %s\n#define %s %d\n", $k, $k, fix($v, 16);
    }
}

sub fix {
    my ($x, $bits) = @_;
    return int($x*(1<<$bits)+.5);
}

foreach $n (4,8,16) {
    next if $asm && $n<16;
    $tf = $ti = "";
    foreach $k (1..$n-1) {
        $c = cos($pi*$k/($n*2));
        define("c$k", $c);
        next if $k==$n/2;
        define("c${k}r2", $c*sqrt(2));
        if($asm) { # C can automatically generate these
          $l = $n-$k;
            $d = cos($pi*$l/($n*2));
            if($k<$n/2) {
                define("c${l}pc${k}:\nc${k}pc${l}", $c+$d);
                define("c${l}r2pc${k}r2:\nc${k}r2pc${l}r2", ($c+$d)*sqrt(2));
            }
            define("c${k}mc${l}", $c-$d);
            define("c${k}r2mc${l}r2", ($c-$d)*sqrt(2));
            define("c${k}t2", $c*2) if $k==12 || $k==4;
            define("c${k}t2pc${l}t2", ($c+$d)*2) if $k==12;
            define("c${k}t2mc${l}t2", ($c-$d)*2) if $k==12;
        } else { # only for lifting based Givens rotation
            $l = $n-$k;
            $cms = ($c-1)/cos($pi*$l/($n*2));
            define("c${k}m1c${l}", $cms);
        }
    }
    define("r2", sqrt(2));
    if($asm) {
        print "section .rodata align=16\n%ifdef USE_FLOAT\n$tf%else\n$ti%endif\n";
    } else {
        print "#if N==$n && defined(USE_FLOAT)\n$tf#endif\n";
        print "#if N==$n && !defined(USE_FLOAT)\n$ti#endif\n";
    }
}
